//
// $Id: hd.cc,v 1.6 2001/07/13 15:15:06 nishi Exp $
//
// Copyright (C) 2001 Shouhei Nishi.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. The name of author may not be used to endorse or promote products
//    derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//





#include "bochs.h"
#include "biosregs.h"
#define LOG_THIS bx_hd_bios.


bx_hd_bios_c bx_hd_bios;
#if BX_USE_HDBIOS_SMF
#define this (&bx_hd_bios)
#endif


bx_hd_bios_c::bx_hd_bios_c(void)
{
}

bx_hd_bios_c::~bx_hd_bios_c(void)
{
  // nothing for now
}


  void
bx_hd_bios_c::init(bx_bios_c *b, bx_disk_bios_c *d)
{
  BX_HD_BIOS_THIS bios = b;
  BX_HD_BIOS_THIS disk_bios = d;
}

  void
bx_hd_bios_c::bios_exec(BX_CPU_C *cpu,
			int type,
			Bit32u addr,
			Bit32u errorno,
			Boolean isPM,
			int &exittype,
			Bit32u &exitaddr,
			Bit16u &exitseg,
			Bit64u &leasttime,
			Bit64u &maxtime)
{
  int drvno;

  drvno = AL & 0x0f;

  BX_INFO(("HD BIOS: call %d %.8x %d:\n",type,addr,isPM));
  cpu->atexit();

notready:
  CH = (CH & 0xff00) | 0x01;
error:
  AH = 0x80;
  goto done;
OK:
  AH = 0x00;
done:
  bx_cpu.set_CF(AH != 0x00);
}
